unit Unit1;

interface               

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, ExtCtrls,
  ImgList, Menus, Face;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    StatusBar1: TStatusBar;
    ImageList1: TImageList; // Reserved indexes: 0-Face; 1-DrawPoint
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    N1: TMenuItem;
    Print1: TMenuItem;
    N2: TMenuItem;
    Save1: TMenuItem;
    Open1: TMenuItem;
    Objects1: TMenuItem;
    Line1: TMenuItem;
    Rect1: TMenuItem;
    Ellipse1: TMenuItem;
    ext1: TMenuItem;
    Help1: TMenuItem;
    About1: TMenuItem;
    Edit1: TMenuItem;
    Paste1: TMenuItem;
    Copy1: TMenuItem;
    N5: TMenuItem;
    Undo1: TMenuItem;
    tDrawFace1: tDrawFace;
    Picture1: TMenuItem;
    Splitter1: TSplitter;
    procedure Line1Click(Sender: TObject);
    procedure Rect1Click(Sender: TObject);
    procedure Ellipse1Click(Sender: TObject);
    procedure Text1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure Print1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure Undo1Click(Sender: TObject);
    procedure Copy1Click(Sender: TObject);
    procedure Paste1Click(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormCreate(Sender: TObject);
    procedure Picture1Click(Sender: TObject);
  private
    { Private declarations }
    procedure LbDblClick(var Msg: tMessage); message WM_LBUTTONDBLCLK;
    procedure MbDblClick(var Msg: tMessage); message WM_MBUTTONDBLCLK;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

uses CompPict, CompPolyline, CompRect, CompEllipse, CompText;

procedure TForm1.Line1Click(Sender: TObject);
begin
  DrawFace.CreateCompIndex:= dciPolyline;
  DrawFace.BeginCommand(csCreate);
end;

procedure TForm1.Rect1Click(Sender: TObject);
begin
  DrawFace.CreateCompIndex:= dciRectangle;
  DrawFace.BeginCommand(csCreate);
end;

procedure TForm1.Ellipse1Click(Sender: TObject);
begin
  DrawFace.CreateCompIndex:= dciEllipse;
  DrawFace.BeginCommand(csCreate);
end;

procedure TForm1.Text1Click(Sender: TObject);
begin
  DrawFace.CreateCompIndex:= dciText;
  DrawFace.BeginCommand(csCreate);
end;

procedure TForm1.Picture1Click(Sender: TObject);
begin
  DrawFace.CreateCompIndex:= dciPicture;
  DrawFace.BeginCommand(csCreate);
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.Open1Click(Sender: TObject);
begin
  DrawFace.Open;
end;

procedure TForm1.Save1Click(Sender: TObject);
begin
  DrawFace.Save;
end;

procedure TForm1.LbDblClick(var Msg: tMessage);
begin
  DrawFace.CompDefaultFunc;
end;

procedure TForm1.MbDblClick(var Msg: tMessage);
begin
  DrawFace.ZoomAll;
end;

procedure TForm1.Print1Click(Sender: TObject);
begin
  DrawFace.Print;
end;

procedure TForm1.About1Click(Sender: TObject);
begin
  DrawFace.AboutBox;
end;

procedure TForm1.Undo1Click(Sender: TObject);
begin
  DrawFace.Undo;
end;

procedure TForm1.Copy1Click(Sender: TObject);
begin
  DrawFace.CopyToClipboard;
end;

procedure TForm1.Paste1Click(Sender: TObject);
begin
  DrawFace.PasteFromClipboard;
end;

procedure TForm1.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  CanClose:= DrawFace.CanClose;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  with DrawFace do
  begin
    InfoPanel0:= StatusBar1.Panels[0];
    InfoPanel1:= StatusBar1.Panels[1];
    InfoPanel2:= StatusBar1.Panels[2];
    InfoPanel3:= StatusBar1.Panels[3];
    AppName:= Application.Title;
  end;
end;

end.
